module 'animation'

local coroutine_tag = _NAME

function run( ... )
    local animations = arg
    local completed = {}

    while true do
        for i = 1, table.getn( animations ) do
            if not completed[ i ] then
                local errors, result = coroutine.resume( animations[ i ] )
                if not errors then error( result ) end
                if not result then
                    completed[ i ] = true
                elseif result ~= coroutine_tag then
                    coroutine.yield( result )
                    local errors, result = coroutine.resume( animations[ i ] )
                    if not errors then error( result ) end
                end
            end
        end
        local is_complete = true
        for i = 1, table.getn( animations ) do
            if not completed[ i ] then is_complete = false end
        end
        if is_complete then break end
    end
end
--[[ fix this to restore completed[] when it returns or bad things will happen
function step( frames, ... )
    local animations = arg
    local completed = {}

    for frame = 1, frames do
        for i = 1, table.getn( animations ) do
            if not completed[ i ] then
                if not coroutine.resume( animations[ i ] ) then
                    completed[ i ] = true
                end
            end
        end
    end
end
]]

function end_frame()
    coroutine.yield( coroutine_tag )
end

function create( ani_func )
    return coroutine.create( ani_func )
end

return _M
