-- evar module with support for evar saving using xLabel.
-- depends on xLabel being loaded before LSLua and the line "Evar ''" in step.rc
-- written by tnl

local lslua = lslua
local type = type
local tostring = tostring
 
module 'xevar'
 
return setmetatable( _M, {
    __index = function( t, k )
        lslua.exec(
            '!ParseEvars !SetEvar Evar "%[exportedEvar(\''.. k ..'\')]%"'
        )
        return lslua._evar 'Evar' ~= 'Evar: '.. k ..' Exists Not'
            and lslua._evar( k ) or nil
    end
    ,
    __newindex = function( t, k, v )
        if type( v ) == 'nil' then v = '' end
        lslua.exec( '!SetEvar '.. k ..' '.. tostring( v ) )
    end
} )
